/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction;

import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Engine;
import com.ibm.hwmca.fw.service.statetransition.Result;
import com.ibm.hwmca.fw.service.statetransition.StateTransitionSupport;
import com.ibm.hwmca.fw.service.statetransition.StateTransitionSupportException;
import com.ibm.hwmca.fw.service.statetransition.Variable;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServiceActionStateEngine {
    private static final String TRACE_MASKT = "XRVSASET";
    private static final String TRACE_MASKF = "XRVSASEF";
    private static final String TRACE_MASKD = "XRVSASED";

    private ServiceActionStateEngine() {
    }

    public static void fire(File rulesFile, Context parentContext, Map userData) throws ServiceActionException {
        Context previousContext = (Context)userData.get("STS_CONTEXT");
        try {
            Trace.trace(TRACE_MASKT, "-> ServiceActionStateEngine.fire( File=" + rulesFile + ", parentContext, Map )");
            Context context = StateTransitionSupport.parseRules(rulesFile, parentContext);
            Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire got the context");
            context.setUserData(userData);
            if (userData.get(SD.KEY_SERVICE_DATA) == null) {
                Trace.trace(TRACE_MASKD, "ServiceActionStateEngine.fire setting up service data container");
                SD serviceData = new SD();
                userData.put(SD.KEY_SERVICE_DATA, serviceData);
            } else {
                Trace.trace(TRACE_MASKD, "ServiceActionStateEngine.fire service data previously set in user map - using it");
            }
            userData.put("STS_CONTEXT", context);
            ServiceActionStateEngine.fire(context);
            userData.put("STS_CONTEXT", previousContext);
        }
        catch (Exception e) {
            userData.put("STS_CONTEXT", previousContext);
            Trace.trace(TRACE_MASKT, "<-! ServiceActionStateEngine.fire Exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (e instanceof ServiceActionException) {
                throw (ServiceActionException)e;
            }
            throw new ServiceActionException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ServiceActionStateEngine.fire( File[], parentContext, Map )");
    }

    public static void fire(File rulesFile, Map userData) throws ServiceActionException {
        Trace.trace(TRACE_MASKT, "-> ServiceActionStateEngine.fire( File=" + rulesFile + ", Map )");
        ServiceActionStateEngine.fire(rulesFile, null, userData);
        Trace.trace(TRACE_MASKT, "<- ServiceActionStateEngine.fire( File[], Map )");
    }

    public static void fire(Context context) throws ServiceActionException {
        Trace.trace(TRACE_MASKT, "-> ServiceActionStateEngine.fire( Context )");
        boolean done = false;
        boolean errorpass = false;
        Engine engine = StateTransitionSupport.createEngine();
        while (!done) {
            try {
                List results = engine.fire(context);
                Result result = null;
                Trace.trace(TRACE_MASKF, "ServiceActionStateEngine: results:[" + results + "]");
                if (results.size() > 1) {
                    String trueRules = "/";
                    Iterator it = results.iterator();
                    while (it.hasNext()) {
                        String ruleName = ((Result)it.next()).getRuleName();
                        trueRules = trueRules + ruleName + "/";
                    }
                    throw new ServiceActionException("ERROR: multiple repair rules true: " + trueRules);
                }
                if (results.size() == 0) {
                    throw new ServiceActionException("ERROR: NO rules returned true");
                }
                result = (Result)results.get(0);
                result.fireEffector(context);
                Variable currentStateVariable = context.getVariable(SD.CURRENT_STATE_VARIABLE);
                Variable previousStateVariable = context.getVariable(SD.PREVIOUS_STATE_VARIABLE);
                previousStateVariable.setValue(currentStateVariable.getValue());
                String currentState = result.getRuleName();
                currentStateVariable.setValue(currentState);
                if (!currentState.equals(SD.EXIT)) continue;
                done = true;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire exception caught: " + e);
                Trace.trace(TRACE_MASKF, e);
                if (errorpass) {
                    Trace.trace(TRACE_MASKT, "<-! ServiceActionStateEngine.fire exception on error recovery path");
                    if (e instanceof ServiceActionException) {
                        throw (ServiceActionException)e;
                    }
                    throw new ServiceActionException(e);
                }
                errorpass = true;
                Variable overallStatus = context.getVariable(SD.OVERALL_STATUS_VARIABLE);
                if (overallStatus != null) {
                    try {
                        overallStatus.setValue(SD.NEW_PROBLEM_DETECTED);
                    }
                    catch (StateTransitionSupportException ste) {
                        Trace.trace(TRACE_MASKT, "<-! ServiceActionStateEngine.fire unable to set OVERALL_STATUS=NEW_PROBLEM_DETECTED. Exception caught: " + ste);
                        throw new ServiceActionException("unable to set OVERALL_STATUS=NEW_PROBLEM_DETECTED. Exception caught: " + ste);
                    }
                }
                Trace.trace(TRACE_MASKF, "ServiceActionStateEngine.fire redriving loop with OVERALL_STATUS=NEW_PROBLEM_DETECTED");
            }
        }
        Trace.trace(TRACE_MASKT, "<- ServiceActionStateEngine.fire( Context )");
    }
}

